@extends('layouts.guest')

@section('content')


<section class="bg-white dark:bg-gray-900">
  <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16 lg:px-6 ">
    <div class="mx-auto max-w-screen-lg text-center mb-8 lg:mb-16">
      <h2 class="mb-4 text-4xl tracking-tight font-extrabold text-gray-900 dark:text-white">About Us</h2>
    </div>

    <div class="bg-gray-100 py-12 px-6 sm:px-12 lg:px-24 rounded-lg">
      <div class="max-w-3xl mx-auto text-center">
        <p class="text-lg text-gray-600 mb-6">
          Welcome to <span class="font-semibold">{{ $restaurant->name }}</span>, where great food and good vibes come
          together! We're a local, family-owned spot that loves bringing people together over delicious meals and
          unforgettable moments. Whether you're here for a quick bite, a family dinner, or a celebration, we’re all
          about making your time with us special.
        </p>
        <p class="text-lg text-gray-600 mb-6">
          Our menu is packed with dishes made from fresh, quality ingredients because we believe food should taste as
          good as it makes you feel. From our signature dishes to seasonal specials, there's always something to excite
          your taste buds.
        </p>
        <p class="text-lg text-gray-600 mb-6">
          But we're not just about the food—we’re about community. We love seeing familiar faces and welcoming new ones.
          Our team is a fun, friendly bunch dedicated to serving you with a smile and making sure every visit feels like
          coming home.
        </p>
        <p class="text-lg text-gray-600">
          So, come on in, grab a seat, and let us take care of the rest. We can't wait to share our love of food with
          you!
        </p>
        <p class="text-lg text-gray-800 font-semibold mt-6">See you soon! 🍽️✨</p>
      </div>
    </div>

  </div>
</section>

@endsection