<div>
    <div
        class="mx-4 p-4 mb-4 bg-white border border-gray-200 rounded-lg shadow-sm dark:border-gray-700 sm:p-6 dark:bg-gray-800">

        @if (restaurant()->license_type != 'paid')
        <x-upgrade-box :title="__('modules.settings.paymentUpgradeHeading')" :text="__('modules.settings.paymentUpgradeInfo')" ></x-upgrade-box>

        @else
        <h3 class="mb-4 text-xl font-semibold dark:text-white">@lang('modules.settings.paymentgatewaySettings')</h3>
        <x-help-text class="mb-6">@lang('modules.settings.paymentHelp')</x-help-text>

        <form wire:submit="submitForm">
            <div class="grid gap-6">

                <div>
                    <x-label for="razorpayStatus">
                        <div class="flex items-center cursor-pointer">
                            <x-checkbox name="razorpayStatus" id="razorpayStatus" wire:model.live='razorpayStatus'  />

                            <div class="ms-2">
                                @lang('modules.settings.enableRazorpay')
                            </div>
                        </div>
                    </x-label>
                </div>

                @if ($razorpayStatus)
                    <div>
                        <x-label for="razorpayKey" value="Razorpay KEY" />
                        <x-input id="razorpayKey" class="block mt-1 w-full" type="text" wire:model='razorpayKey' />
                        <x-input-error for="razorpayKey" class="mt-2" />
                    </div>

                    <div>
                        <x-label for="razorpaySecret" value="Razorpay SECRET" />
                        <x-input id="razorpaySecret" class="block mt-1 w-full" type="text" wire:model='razorpaySecret' />
                        <x-input-error for="razorpaySecret" class="mt-2" />
                    </div>
                @endif

                <div>
                    <x-label for="stripeStatus">
                        <div class="flex items-center cursor-pointer">
                            <x-checkbox name="stripeStatus" id="stripeStatus" wire:model.live='stripeStatus'  />

                            <div class="ms-2">
                                @lang('modules.settings.enableStripe')
                            </div>
                        </div>
                    </x-label>
                </div>

                @if ($stripeStatus)
                    <div>
                        <x-label for="stripeKey" value="Stripe KEY" />
                        <x-input id="stripeKey" class="block mt-1 w-full" type="text" wire:model='stripeKey' />
                        <x-input-error for="stripeKey" class="mt-2" />
                    </div>

                    <div>
                        <x-label for="stripeSecret" value="Stripe SECRET" />
                        <x-input id="stripeSecret" class="block mt-1 w-full" type="text" wire:model='stripeSecret' />
                        <x-input-error for="stripeSecret" class="mt-2" />
                    </div>
                @endif

                <div>
                    <x-button>@lang('app.save')</x-button>
                </div>
            </div>
        </form>
        @endif
    </div>

</div>
