<x-dialog-modal wire:model.live="showAddCustomerModal">
    <x-slot name="title">
        <h2 class="text-lg">@lang('modules.customer.addCustomer')</h2>
    </x-slot>

    <x-slot name="content">
        <form wire:submit="submitForm">
            @csrf
            <div class="space-y-4">
                       
                <div>
                    <x-label for="customer_name" value="{{ __('modules.customer.name') }}" />
                    <x-input id="customer_name" class="block mt-1 w-full" type="text" name="menu_name" autofocus wire:model='customerName' />
                    <x-input-error for="customerName" class="mt-2" />
                </div>
                <div>
                    <x-label for="customerPhone" value="{{ __('modules.customer.phone') }}" />
                    <x-input id="customerPhone" class="block mt-1 w-full" type="tel" name="customerPhone"  wire:model='customerPhone' />
                    <x-input-error for="customerPhone" class="mt-2" />
                </div>
                <div>
                    <x-label for="customerEmail" value="{{ __('modules.customer.email') }}" />
                    <x-input id="customerEmail" class="block mt-1 w-full" type="email" name="customerEmail"  wire:model='customerEmail' />
                    <x-input-error for="customerEmail" class="mt-2" />
                </div>
                <div>
                    <x-label for="customerAddress" value="{{ __('modules.customer.address') }}" />
                    <x-textarea id="customerAddress" class="block mt-1 w-full" name="customerAddress" rows="3" wire:model='customerAddress' />
                    <x-input-error for="customerAddress" class="mt-2" />
                </div>
            </div>
               
            <div class="flex w-full pb-4 space-x-4 mt-6">
                <x-button>@lang('app.save')</x-button>
                <x-button-cancel  wire:click="$set('showAddCustomerModal', false)">@lang('app.cancel')</x-button-cancel>
            </div>
        </form>
    </x-slot>
</x-dialog-modal>
