<!DOCTYPE html>
{{--<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ (isRtl() ? 'rtl' : '') }}">--}}
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
{{--    <meta name="csrf-token" content="{{ csrf_token() }}">--}}
    <link rel="icon" type="image/png" sizes="16x16" href="{{global_setting()->logoUrl}}">
    <link rel="manifest" href="{{global_setting()->logoUrl}}">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="{{global_setting()->logoUrl}}">

    <title>{{global_setting()->name}}</title>
    <title>{{global_setting()->logoUrl}}</title>

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Styles -->
    @livewireStyles

    @include('sections.theme_style')

    <script src="https://js.pusher.com/beams/1.0/push-notifications-cdn.js" async></script>

    <script>
        if (localStorage.getItem('color-theme') === 'dark' || (!('color-theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark')
        } else {
            document.documentElement.classList.remove('dark')
        }

    </script>

</head>

<body class="font-sans antialiased dark:bg-gray-900">

    @if (user()->restaurant_id)
        @livewire('navigation-menu')
    @else
        @livewire('superadmin-navigation-menu')
    @endif

    <div class="flex pt-16 overflow-hidden bg-gray-50 dark:bg-gray-900">

        @if (user()->restaurant_id)
            @livewire('sidebar')
        @else
            @livewire('superadmin-sidebar')
        @endif


        <div id="main-content" class="relative w-full h-full overflow-y-auto bg-gray-50 lg:ml-64 dark:bg-gray-900">
            <main>
{{--                TO BE ENABED BASED ON ROUTE WHEN WE WANT SUBSCRIPTION--}}
{{--                @if(restaurant()->license_type == 'paid')--}}
{{--                    @livewire('license-expire')--}}
{{--                @else--}}
{{--                    @yield('content')--}}
{{--                    {{ $slot ?? ''}}--}}
{{--                @endif--}}

                    @yield('content')
                    {{ $slot ?? ''}}
            </main>


        </div>


    </div>

    @stack('modals')


    @livewireScripts
    @include('layouts.update-uri')

    <script src="{{ asset('vendor/livewire-alert/livewire-alert.js') }}" defer data-navigate-track></script>
    <x-livewire-alert::flash />

    @if (user()->restaurant_id)
        <script src="https://checkout.razorpay.com/v1/checkout.js"></script>

        @livewire('order.OrderDetail')

        @livewire('customer.addCustomer')

        @livewire('settings.upgradeLicense')

        @livewire('order.addPayment')


        <script src="https://js.stripe.com/v3/"></script>

        <form action="{{ route('stripe.license_payment') }}" method="POST" id="license-payment-form" class="hidden">
            @csrf

            <input type="hidden" id="license_payment" name="license_payment">

            <div class="form-row">
                <label for="card-element">
                    Credit or debit card
                </label>
                <div id="card-element">
                    <!-- A Stripe Element will be inserted here. -->
                </div>

                <!-- Used to display Element errors. -->
                <div id="card-errors" role="alert"></div>
            </div>

            <button>Submit Payment</button>
        </form>

        @if (superadminPaymentGateway()->stripe_status)
            <script>
                const stripe = Stripe('{{ superadminPaymentGateway()->stripe_key }}');
                const elements = stripe.elements({
                    currency: '{{ strtolower(restaurant()->currency->currency_code) }}',
                });
            </script>
        @endif

    @endif


    @if (App::environment('codecanyon'))
    <script>
        const currentUserId = "tbltrk-{{ auth()->id() }}"; // Get this from your auth system

        const beamsClient = new PusherPushNotifications.Client({
            instanceId: "{{ pusherSettings()->instance_id }}",
        });

        const beamsTokenProvider = new PusherPushNotifications.TokenProvider({
            url: "{{ route('beam_auth') }}",
        });

        beamsClient.start()
        .then(() => beamsClient.addDeviceInterest('Tabletrack'))
        .then(() => beamsClient.setUserId(currentUserId, beamsTokenProvider))
        .then(() => console.log('Successfully registered and subscribed!'))
        .catch(console.error);

        beamsClient
        .getUserId()
        .then((userId) => {
            console.log(userId, currentUserId);
            // Check if the Beams user matches the user that is currently logged in
            if (userId !== currentUserId) {
            // Unregister for notifications
            return beamsClient.stop();
            }
        })
        .catch(console.error);
    </script>
    @endif

    @stack('scripts')
</body>

</html>
