<?php

namespace App\Livewire\Order;

use App\Models\Order;
use App\Models\Payment;
use App\Models\Table;
use App\Notifications\SendOrderBill;
use Livewire\Attributes\On;
use Livewire\Component;

class AddPayment extends Component
{

    public $order;
    public $paymentMethod = 'cash';
    public $paymentAmount = 0;
    public $balanceAmount = 0;
    public $returnAmount = 0;
    public $dueAmount = 0;
    public $showAddPaymentModal = false;
    
    #[On('showPaymentModal')]
    public function showPaymentModal($id)
    {
        $this->order = Order::find($id);
        $this->balanceAmount = ($this->order->total - $this->order->amount_paid);
        $this->showAddPaymentModal = true;
        $this->dueAmount = ((($this->order->total - (float)$this->paymentAmount - (float)$this->balanceAmount) < 0) ? 0 : ($this->order->total - (float)$this->paymentAmount - (float)$this->balanceAmount));
    }
    
    public function setbalanceAmount()
    {
        $balance = (($this->order->total - $this->order->amount_paid) - ((float)$this->paymentAmount ?? 0));
        $this->balanceAmount = ((float)$balance < 0) ? 0 : (float)$balance;

        if ($this->paymentMethod == 'cash') {
            $this->returnAmount = ($this->order->total - $this->order->amount_paid) - ((float)$this->balanceAmount ?? 0);

        } else {
            $this->returnAmount = ($balance < 0) ? $balance : 0;

        }
    }

    public function setReturnAmount()
    {
        $balance = (($this->order->total - $this->order->amount_paid) - ((float)$this->balanceAmount ?? 0));
        $this->returnAmount = ($balance < 0) ? $balance : 0;
    }

    public function resetPayment()
    {
        $this->paymentAmount = 0;
        $this->balanceAmount = ($this->paymentMethod == 'due') ? 0 : ($this->order->total - $this->order->amount_paid);
        $this->returnAmount = 0;
    }

    public function submitForm()
    {
        if ($this->paymentAmount > 0) {
            Payment::create([
                'order_id' => $this->order->id,
                'payment_method' => $this->paymentMethod,
                'amount' => $this->paymentAmount
            ]);
        }

        if ($this->balanceAmount > 0) {
            Payment::create([
                'order_id' => $this->order->id,
                'payment_method' => 'cash',
                'amount' => $this->balanceAmount
            ]);
        }

        $dueAmount = ($this->order->total - $this->order->amount_paid - (float)$this->paymentAmount - (float)$this->balanceAmount);

        Payment::where('order_id', $this->order->id)->where('payment_method', 'due')->delete();

        if ($dueAmount > 0) {
            Payment::create([
                'order_id' => $this->order->id,
                'payment_method' => 'due',
                'amount' => $dueAmount
            ]);
        }

        $this->order->amount_paid = ($this->order->amount_paid + (float)$this->paymentAmount + (float)$this->balanceAmount);
        $this->order->status = ($dueAmount > 0) ? 'payment_due' : 'paid';
        $this->order->save();

        Table::where('id', $this->order->table_id)->update([
            'available_status' => 'available'
        ]);

        if (!is_null($this->order->customer_id)) {
            $this->order->customer->notify(new SendOrderBill($this->order));
        }

        $this->dispatch('showOrderDetail', id: $this->order->id);
        $this->dispatch('refreshOrders');
        $this->dispatch('resetPos');
        $this->dispatch('refreshPayments');

        $this->showAddPaymentModal = false;

        $this->resetPayment();

        // return $this->redirect(route('orders.index'), navigate: true);

    }

    public function render()
    {
        return view('livewire.order.add-payment');
    }

}
