<?php

namespace App\Http\Controllers;

use App\Exports\CustomerExport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class CustomerController extends Controller
{

    public function index()
    {
        abort_if((!user_can('Show Customer')), 403);
        return view('customers.index');
    }

    public function export()
    {
        return Excel::download(new CustomerExport, 'customers-'.now()->toDateTimeString().'.xlsx');
    }

}
